#include "testlib.h"

bool isPrime(int n){
	if(n < 2)return false;
	int m = (int)sqrt(n + 0.5);
	for(int i = 2; i <= m; ++i){
		if(n % i == 0)return false;
	}
	return true;
}

int main(int argc, char *argv[])
{
    registerTestlibCmd(argc, argv);
	
	int n = inf.readInt(1, 2147483647);
	
	int p1, p2;
	
	p1 = ouf.readInt(1, 2147483647);
	p2 = ouf.readInt(1, 2147483647);
	
	if(!isPrime(p1)){
		quitf(_wa, "Wrong answer. The first number %d is not prime.", p1);
	}
	
	else if(!isPrime(p2)){
		quitf(_wa, "Wrong answer. The second number %d is not prime.", p2);
	}
	
	else if(p1 + p2 != n){
		quitf(_wa, "Wrong answer. The sum of two numbers is not equal to %d", n);
	}
	
	else{
		quitf(_ok, "CORRECT! 2 numbers.");
	}

    return 0;
}
