#include <stdlib.h>
#include <iostream>
#include <cstdio>
#include <cstring>
#include <cmath>
#include <sstream>
#include <vector>
#include <cctype>
#include <algorithm>
using namespace std;
#define _ok 0
#define _wa 1
#define quitf(x,...) exit(x)

FILE *f_in, *f_out, *f_user;

bool is_whitespace(char c)
{
    return c == ' ' || c == '\t' || c == '\n' || c == '\r';
}

int read_int(FILE *f)
{
    int ret;
    if(fscanf(f, "%d", &ret) != 1)
    {
		cout << 0 << endl;
        exit(_wa);
    }
    return ret;
}

int out_read_int(FILE *f)
{
    int ret;
    fscanf(f, "%d", &ret);
    return ret;
}

long long read_long_long(FILE *f)
{
    long long ret;
    if(fscanf(f, "%lld", &ret) != 1)
    {
		cout << 0 << endl;
		cerr << "Wrong Answer." << endl;
        exit(_wa);
    }
    return ret;
}

long long out_read_long_long(FILE *f)
{
    long long ret;
    fscanf(f, "%lld", &ret);
    return ret;
}

void read_until_eof(FILE *f)
{
    char ch = fgetc(f);
    while (ch != EOF && is_whitespace(ch))
    {
        ch = fgetc(f);
    }
    if (ch != EOF)
    {
		cout << 0 << endl;
		cerr << "The output is longer than standard output." << endl;
        exit(_wa);
    }
}

long long a[105];
int main(int argc, char* argv[])
{
    f_in = fopen("input", "r");  // ׼ļ
    f_out = fopen("answer", "r"); // ׼ļ
    f_user = fopen("user_out", "r");// ûļ
    int T, n, nn, i;
    long long sum, k;
    T = out_read_int(f_in);
    while(T--)
    {
        k = out_read_long_long(f_in);
        n = read_int(f_user);
        if(n < 1 || n > 100){
			cout << 0 << endl;
			cerr << "The number of coin $n$ does not in the range [1, 100]" << endl;
            exit(_wa);
		}
		
        nn = out_read_int(f_out);
        if(n != nn){
			cout << 0 << endl;
			cerr << "The minimum required coins is: "<< nn << ", Found: " << n << endl;
            exit(_wa);
		}
		
        for(i=0; i<n; i++)
        {
            a[i] = out_read_long_long(f_out);
            a[i] = read_long_long(f_user);
            if(a[i] < 1 || a[i] > k){
				cout << 0 << endl;
				cerr << "Wrong answer | Your answer is not correct." << endl;
                exit(_wa);
			}
        }
        sort(a,a+n);
        sum=0;
        for(i=0; i<n; i++)
        {
            if(a[i]>sum+1){
				cout << 0 << endl;
				cerr << "The amount " << sum << "cannot be formed" << endl;
                exit(_wa);
			}
            sum+=a[i];
        }
        if(sum!=k){
			cout << 0 << endl;
			cerr << "The sum of coins does not equal to $k$" << endl;
            exit(_wa);
		}
    }
	
    read_until_eof(f_user);
	
	cout << 100 << endl;
	cerr << "Correct. | " << n << " number(s)." << endl;
	
    return 0;
}
